﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls;

namespace WinfootDefaultSystemPlugin
{
    public partial class MainPanel : UserControl,IControl
    {
        public MainPanel()
        {
            InitializeComponent();

            //適用可能なコントロールを決定
            WFUtillity wfUtillity = new WFUtillity();
            List<ICorrespondenceOS> ControlList = new List<ICorrespondenceOS>
            {
                new  IsShortcut(),
                new  EncryptionContextMenu(),
                new MinAnimate(),
                new ClearRecentDocsOnExit(),
                new NoWinKeys(),
                new MenuShowDelay(),
                new Jpn98FixPitch(),
                new NoStrCmpLogical(),
                new InitialKeyboardIndicators(),
                new NoSaveSettings(),
                new PersistBrowsers(),
                new SafeDllSearchMode(),
                new SmoothScroll(),
                new ClearPageFileAtShutdown(),
                new DesktopProcess(),
                new ForceCopyAclwithFile(),
                new NoThumbnailCache(),
                new AutoEndTasks(),
                new Link(),
                new ClassicShell(),
                new HungAppTimeout(),
                new WaitToKillServiceTimeout(),
                new ForegroundFlashCount(),
                new MaxRecentDocs(),
                new ThumbnailQuality(),
                new WaitToKillAppTimeout(),
                new ForegroundLockTimeout(),
                new ShellIconSize(),
                new ThumbnailSize(),
                new TaskbarGroupSize(),
            };
            for (int count = 0; count < ControlList.Count; count++)
            {
#if DEBUG
                flowLayoutPanel1.Controls.Add(((System.Windows.Forms.Control)ControlList[count]));
#else
                if (wfUtillity.CheckCorrespondence(ControlList[count]))
                {
                    flowLayoutPanel1.Controls.Add(((System.Windows.Forms.Control)ControlList[count]));
                }
#endif
            }
        }

        #region IControl メンバ

        public void Apply()
        {
            for (int count = 0; count < this.Controls.Count; count++)
            {
                if (this.Controls[count] is IControl)
                {
                    ((IControl)this.Controls[count]).Apply();
                }
            }
        }

        public List<WFRegistry> BackUp()
        {
            List<WFRegistry> wfRegistries = new List<WFRegistry>();
            for (int count = 0; count < flowLayoutPanel1.Controls.Count; count++)
            {
                if (flowLayoutPanel1.Controls[count] is IControl)
                {
                    wfRegistries.AddRange(((IControl)flowLayoutPanel1.Controls[count]).BackUp());
                }
            }

            return wfRegistries;
        }

        #endregion
    }
}
